/*
 * To compile, use this command line:
 *   gcc -Os -fomit-frame-pointer -mdynamic-no-pic -s launcher.c -o launcher -framework Carbon
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <Carbon/Carbon.h>

/*
 * Code for finding an application by bundle id lifted from Mojopatch, under
 *  the zlib license: http://icculus.org/mojopatch/
 */


static int do_msgbox(const char *str, AlertType alert_type,
                     AlertStdCFStringAlertParamRec *param,
                     DialogItemIndex *idx)
{
    const char *_title = "Apocalypse Weekend";
    int retval = 0;
    DialogItemIndex val = 0;
    CFStringRef title = CFStringCreateWithBytes(NULL, _title, strlen(_title),
                                                kCFStringEncodingISOLatin1, 0);
    CFStringRef msg = CFStringCreateWithBytes(NULL, str, strlen(str),
                                                kCFStringEncodingISOLatin1, 0);
    if ((msg != NULL) && (title != NULL))
    {
        DialogRef dlg = NULL;

        if (CreateStandardAlert(alert_type, title, msg, param, &dlg) == noErr)
        {
            RunStandardAlert(dlg, NULL, (idx) ? idx : &val);
            retval = 1;
        } /* if */
    } /* if */

    if (msg != NULL)
        CFRelease(msg);

    if (title != NULL)
        CFRelease(title);

    return(retval);
} /* do_msgbox */

static void ui_msgbox(const char *str)
{
    do_msgbox(str, kAlertNoteAlert, NULL, NULL);
} /* ui_msgbox_carbon */

int locate_product_by_identifier(const char *str, char *buf, size_t bufsize)
{
    /* Ask LaunchServices to find product by identifier... */
    OSStatus rc;
    CFURLRef url = NULL;
    CFStringRef id = CFStringCreateWithBytes(NULL, str, strlen(str),
                                             kCFStringEncodingISOLatin1, 0);

    rc = LSFindApplicationForInfo(kLSUnknownCreator, id, NULL, NULL, &url);
    CFRelease(id);
    if (rc == noErr)
    {
        int b = (int) CFURLGetFileSystemRepresentation(url, TRUE, buf, bufsize);
        if (b) b = 1;
        CFRelease(url);
        if ((b) && (strstr(buf, "/.Trash/")))
        {
            ui_msgbox("It looks like your Postal 2 installation is in the Trash can."
                    " Please take it out of the trash first."
                    " If this is an old installation, please empty your"
                    " trash so we find the right one.");
            b = -1;
        } /* if */

        return(b);
    } /* if */

    return(0);
} /* locate_product_by_identifier */


int main(int argc, char **argv)
{
    char buf[2048];
    int rc = locate_product_by_identifier("com.runningwithscissors.postal2", buf, sizeof (buf));

    if (!rc)
        ui_msgbox("Failed to find Postal 2...please make sure it is installed!");

    else if (rc == 1)
    {
        if (chdir(buf) != -1)
        {
            if (chdir("./System") != -1)
            {
                execl("./postal2-bin", "./postal2-bin",
                      "-INI=ApocalypseWeekend.ini",
                      "-USERINI=ApocalypseWeekendUser.ini",
                      "-SAVEDGAMEINI=ApocalypseWeekendSavedGameInfo.ini",
                      "-BASEDIR=../ApocalypseWeekend/System",
                      NULL);
            } /* if */
        } /* if */
        ui_msgbox("Failed to launch Apocalypse Weekend! Reinstalling Postal 2 and/or the expansion pack may fix this.");
    } /* else if */

    return(1);
} /* main */

/* end of launcher.c ... */

